﻿using PpmsDataWebService.Models;
using PpmsDataWebService.Mappers;
using VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using Microsoft.AspNet.OData;
using Microsoft.AspNet.OData.Routing;
using System.Web.Http.Description;
using Microsoft.Web.Http;

namespace PpmsDataWebService.Controllers
{

    //[Authorize]
    [EnableQuery]
    [ApiVersion("1.0")]
    public class ProviderLicensesController : ODataController
    {
        [ODataRoute("ProviderLicenses({LicenseNumber})")]
        public async Task<HttpResponseMessage> Get([FromODataUri] string LicenseNumber)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderLicense =
                    context.ppms_providerlicensureSet.FirstOrDefault(x => x.ppms_name.Equals(LicenseNumber));
                if (ppmsProviderLicense != null)
                {
                    var ppmsProviderLicensesList = new List<ppms_providerlicensure> {ppmsProviderLicense};
                    var providerLicenses = await ProviderLicensesMap.MapProviderLicenses(ppmsProviderLicensesList, queryType, context);
                    return Request.CreateResponse(providerLicenses);            
                }
                var message = string.Format("Provider License with Number: {0} not found", LicenseNumber);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        //Returns only the related Provider Licenses       
        [ODataRoute("ProviderLicenses({LicenseNumber})/Provider")]
        public async Task<HttpResponseMessage> GetProvider([FromODataUri] string LicenseNumber)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderLicense =
                    context.ppms_providerlicensureSet.FirstOrDefault(x => x.ppms_name.Equals(LicenseNumber));
                if (ppmsProviderLicense != null)
                {
                    //Retrieve and Return the related Provider
                    var ppmsProvider =
                        context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderLicense.ppms_ProviderIdId.Id);
                    var ppmsProvidersList = new List<Account> { ppmsProvider };
                    var provider =
                        await ProviderMap.MapProviders(ppmsProvidersList, "None");
                    return Request.CreateResponse(provider);
                }
                var message = string.Format("Provider with Provider License Number: {0} not found", LicenseNumber);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        [ODataRoute("ProviderLicenses")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Providers in the system. . 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderLicenses = context.ppms_providerlicensureSet.Where(i => i.ppms_name != null && i.ppms_ProviderIdId !=null).Take(50);
                var ppmsProviderLicensesList = ppmsProviderLicenses.ToList();
                if (ppmsProviderLicensesList.Any())
                {
                    //Map Providers
                    var providerLicenses = await ProviderLicensesMap.MapProviderLicenses(ppmsProviderLicensesList, "None", context);
                    return Request.CreateResponse(providerLicenses);
                }
                var message = "Provider Licenses Not Found";
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }
    }
}